#include <iostream>
#include <string>
#include <fstream>
#include <iomanip>
#include <vector>
#include <map>
#include <array>
#include <stdlib.h>

std::ifstream input("input");
std::ifstream answer("answer");
std::ifstream user_out("user_out");

void WA() {
    std::cout << 0 << '\n';
    exit(0);
}
void AC() {
    std::cout << 100 << '\n';
    exit(0);
}

void str_clear(std::string& str) {
    while (!str.empty() && (str.back() == ' ' || str.back() == '\r' || str.back() == '\n' || str.back() == '\0'))
        str.pop_back();
}

int main() {
    std::string str;
    std::vector<std::string> user;
    while (getline(user_out, str)) {
        str_clear(str);
        user.push_back(str);
    }
    while (!user.empty() && user.back().empty()) {
        user.pop_back();
    }
    if (user.size() == 0) std::cerr << "Your output is empty.\n", WA();

    getline(answer, str);
    str_clear(str);
    if (str == "DIE") {
        if (user[0] == "DIE") {
            if (user.size() != 1) std::cerr << "The expected Answer is DIE, but you output more than one lines.\n", WA();
            AC();
        }
        else std::cerr << "The expected Answer is DIE, but you output a solution.\n", WA();
    }

    int n, m;
    input >> m >> n;
    if (user.size() != m) {
        std::cerr << "The number of lines in your output is not equal to " << m << ".\n";
        WA();
    }

    std::map<std::string, std::array<int, 3>> mp;
    std::vector<std::string> exam(m + 1, "");
    for (int i = 1; i <= n; i++) {
        int s, d, c;
        input >> str >> s >> d >> c;
        exam[d] = str;
        mp[str] = {s, d, c};
    }
    for (int i = 1; i <= m; i++) {
        str = user[i - 1];
        if (str == "REST") {
            if (exam[i].empty()) continue;
            else std::cerr << "In the " << i << " line: The expected Answer is EXAM, but your output is REST.\n", WA();
        }
        else if (str == "EXAM") {
            if (exam[i].empty()) std::cerr << "In the" << i << " line: There is no EXAM in this day, but your output is EXAM.\n", WA();
            if (mp[exam[i]][2] > 0) std::cerr << "In the " << i << " line: The review number of \"" << exam[i] << "\" is not enough.\n", WA();
        }
        else {
            if (!exam[i].empty()) std::cerr << "In the " << i << " line: The expected Answer is EXAM, but your output is \"" << str << "\".\n", WA();
            if (!mp.count(str)) std::cerr << "In the " << i << " line: You output \"" << str << "\", but not have a \"" << str << "\" course.\n", WA();
            if (mp[str][0] <= i && i < mp[str][1]) --mp[str][2];
            else std::cerr << "In the " << i << " line: The time of \"" << str << "\" should be [" << mp[str][0] << ", " << mp[str][1] << "), but your output is " << i << ".\n", WA();
        }
    }
    AC();

    return 0;
}